//#ifndef _MT2060M_H_
//#define _MT2060M_H_
#ifndef _FS803A_H_
#define _FS803A_H_

//#include "mt_errordef.h"
#include "linux/kernel.h"

typedef unsigned char   U8Data;         /*  type corresponds to 8 bits      */
typedef unsigned long   UData_t;        /*  type must be at least 32 bits   */
typedef int             SData_t;        /*  type must be at least 32 bits   */
typedef void *          Handle_t;       /*  memory pointer type             */
typedef double          FData_t;        /*  floating point data type        */

#define MAX_ZONES 48
#define MT_TUNER_CNT               (2)  /*  total num of MicroTuner tuners  */
#define MAX_UDATA         (4294967295)  /*  max value storable in UData_t   */
#define MT_TUNER_CNT               (2)  /*  total num of MicroTuner tuners  */
#define MT_IS_ERROR(s) (((s) >> 30) != 0)
#define MT_NO_ERROR(s) (((s) >> 30) == 0)

#define MAX_ZONES 48

#define ceil(n, d) (((n) < 0) ? (-((-(n))/(d))) : (n)/(d) + ((n)%(d) != 0))
#define uceil(n, d) ((n)/(d) + ((n)%(d) != 0))
#define floor(n, d) (((n) < 0) ? (-((-(n))/(d))) - ((n)%(d) != 0) : (n)/(d))
#define ufloor(n, d) ((n)/(d))

#define REF_FREQ          (16000000UL)  /* Reference oscillator Frequency (in Hz) */
#define IF1_FREQ        (1220000000UL)  /* Default IF1 Frequency (in Hz) */
#define IF1_CENTER      (1220000000UL)  /* Center of the IF1 filter (in Hz) */
#define IF1_BW            (22000000UL)  /* The IF1 filter bandwidth (in Hz) */
#define TUNE_STEP_SIZE       (50000UL)  /* Tune in steps of 50 kHz */
#define SPUR_STEP_HZ        (250000UL)  /* Step size (in Hz) to move IF1 when avoiding spurs */
#define LO1_STEP_SIZE       (250000UL)  /* Step size (in Hz) of PLL1 */
#define ZIF_BW             (3000000UL)  /* Zero-IF spur-free bandwidth (in Hz) */
#define MAX_HARMONICS_1          (5UL)  /* Highest intra-tuner LO Spur Harmonic to be avoided */ 
#define MAX_HARMONICS_2          (5UL)  /* Highest inter-tuner LO Spur Harmonic to be avoided */ 
#define MIN_LO_SEP         (1000000UL)  /* Minimum inter-tuner LO frequency separation */
#define LO1_FRACN_AVOID    (2999999UL)  /* LO1 FracN numerator avoid region (in Hz) */
#define LO2_FRACN_AVOID      (99999UL)  /* LO2 FracN numerator avoid region (in Hz) */
#define MIN_FIN_FREQ      (48000000UL)  /* Minimum input frequency (in Hz) */
#define MAX_FIN_FREQ     (860000000UL)  /* Maximum input frequency (in Hz) */
#define MIN_FOUT_FREQ     (30000000UL)  /* Minimum output frequency (in Hz) */
#define MAX_FOUT_FREQ     (60000000UL)  /* Maximum output frequency (in Hz) */
#define MIN_DNC_FREQ    (1041000000UL)  /* Minimum LO2 frequency (in Hz) */
#define MAX_DNC_FREQ    (1310000000UL)  /* Maximum LO2 frequency (in Hz) */
#define MIN_UPC_FREQ    (1088000000UL)  /* Minimum LO1 frequency (in Hz) */
#define MAX_UPC_FREQ    (2214000000UL)  /* Maximum LO1 frequency (in Hz) */



struct MT_ExclZone_t;

struct MT_ExclZone_t
{
    UData_t         min_;
    UData_t         max_;
    struct MT_ExclZone_t*  next_;
};
typedef struct _UserData
{
    Handle_t    handle;
    U8Data      Demod2WireAddr;
    U8Data      SlaveDemod;
}UserData, *PUserData;




typedef struct
{
    UData_t nAS_Algorithm;
    UData_t f_ref;
    UData_t f_in;
    UData_t f_LO1;
    UData_t f_if1_Center;
    UData_t f_if1_Request;
    UData_t f_if1_bw;
    UData_t f_LO2;
    UData_t f_out;
    UData_t f_out_bw;
    UData_t f_LO1_Step;
    UData_t f_LO2_Step;
    UData_t f_LO1_FracN_Avoid;
    UData_t f_LO2_FracN_Avoid;
    UData_t f_zif_bw;
    UData_t f_min_LO_Separation;
    UData_t maxH1;
    UData_t maxH2;
    UData_t bSpurPresent;
    UData_t bSpurAvoided;
    UData_t nSpursFound;
    UData_t nZones;
    struct MT_ExclZone_t* freeZones;
    struct MT_ExclZone_t* usedZones;
    struct MT_ExclZone_t MT_ExclZones[MAX_ZONES];
} MT_AvoidSpursData_t;


#define    PART_REV 0   	   //*  0x00: Part/Rev Code        
#define    LO1C_1 0x01         //*  0x01: LO1C Byte 1          
#define    LO1C_2 0x02         //*  0x02: LO1C Byte 2         
#define    LO2C_1 0x03         //*  0x03: LO2C Byte 1         
#define    LO2C_2 0x04         //*  0x04: LO2C Byte 2         
#define    LO2C_3 0x05         //*  0x05: LO2C Byte 3         
#define    LO_STATUS 0x06      //*  0x06: LO Status Byte      
#define    FM_FREQ 0x07        //*  0x07: FM FREQ Byte        
#define    MISC_STATUS 0x08    //*  0x08: Misc Status Byte    
#define    MISC_CTRL_1 0x09    //*  0x09: Misc Ctrl Byte 1    
#define    MISC_CTRL_2 0x0A    //*  0x0A: Misc Ctrl Byte 2    
#define    MISC_CTRL_3 0x0B    //*  0x0B: Misc Ctrl Byte 3    
#define    LO1_1 0x0C          //*  0x0C: LO1 Byte 1          
#define    LO1_2 0x0D          //*  0x0D: LO1 Byte 2          
#define    END_REGS 0x0E


typedef struct
{
    Handle_t    handle;
    Handle_t    hUserData;
    UData_t     address;
    UData_t     version;
    UData_t     tuner_id;
    MT_AvoidSpursData_t AS_Data;
    UData_t     f_IF1_actual;
    UData_t     num_regs;
    U8Data      reg[END_REGS];
    UData_t     RF_Bands[10];
}  FS803_Info_t;


UData_t InitFS803(
    Handle_t        handle,
    U8Data          ucDemod2WireAddr,
    U8Data          ucSlaveDemod,
    U8Data		    ucTuner2WireAddr,
    void *		    pData
);

UData_t SetFS803(
    Handle_t	handle,
    U8Data      ucDemod2WireAddr,
    U8Data      ucSlaveDemod,
    U8Data		ucTuner2WireAddr,
    UData_t		dwFreq,
    U8Data      ucBw
);

UData_t AdjustFS803(
    Handle_t	handle,
    U8Data      ucDemod2WireAddr,
    U8Data      ucSlaveDemod,
    U8Data		ucTuner2WireAddr,
    U8Data      ucStrong
);

UData_t CalibrateFS803(
    Handle_t    handle,
    U8Data      ucDemod2WireAddr,
    U8Data      ucSlaveDemod,
    U8Data      ucTuner2WireAddr,
    UData_t     f_in,
	UData_t     f_out,
    UData_t*    f_IF1,
    SData_t*    P_max,
    void *      pf,
    void *      pp
);

UData_t FS803_Open(
					UData_t FS803_Addr,
                    Handle_t* hFS803,
                    Handle_t hUserData,
                    Handle_t* FS803_Info
);

UData_t FS803_LocateIF1(
						 Handle_t h, 
                         UData_t f_in, 
                         UData_t f_out, 
                         UData_t* f_IF1, 
                         SData_t* P_max,
                         SData_t *pf,
                         SData_t *pp
);

/*
**  Parameter for function MT2060_GetParam & MT2060_SetParam that 
**  specifies the tuning algorithm parameter to be read/written.
*/
typedef enum
{
    /*  tuner address                                  set by MT2060_Open() */
    FS803_IC_ADDR,

    /*  max number of MT2060 tuners       set by MT2060_CNT in mt_userdef.h */
    FS803_MAX_OPEN,

    /*  current number of open MT2060 tuners           set by MT2060_Open() */
    FS803_NUM_OPEN,
    
    /*  crystal frequency                            (default: 16000000 Hz) */
    FS803_SRO_FREQ,

    /*  min tuning step size                            (default: 50000 Hz) */
    FS803_STEPSIZE,

    /*  input center frequency                   set by MT2060_ChangeFreq() */
    FS803_INPUT_FREQ,

    /*  LO1 Frequency                            set by MT2060_ChangeFreq() */
    FS803_LO1_FREQ,
              
    /*  LO1 minimum step size                          (default: 250000 Hz) */
    FS803_LO1_STEPSIZE,
    
    /*  LO1 FracN keep-out region                     (default: 2999999 Hz) */
    FS803_LO1_FRACN_AVOID,

    /*  Current 1st IF in use                    set by MT2060_ChangeFreq() */
    FS803_IF1_ACTUAL,
          
    /*  Requested 1st IF                         set by MT2060_ChangeFreq() */
    FS803_IF1_REQUEST,
                
    /*  Center of 1st IF SAW filter                     located by customer */
    FS803_IF1_CENTER,
                    
    /*  Bandwidth of 1st IF SAW filter               (default: 22000000 Hz) */
    FS803_IF1_BW,
                    
    /*  zero-IF bandwidth                             (default: 3000000 Hz) */
    FS803_ZIF_BW,

    /*  LO2 Frequency                            set by MT2060_ChangeFreq() */
    FS803_LO2_FREQ,

    /*  LO2 minimum step size                           (default: 50000 Hz) */
    FS803_LO2_STEPSIZE,

    /*  LO2 FracN keep-out region                       (default: 99999 Hz) */
    FS803_LO2_FRACN_AVOID,

    /*  output center frequency                  set by MT2060_ChangeFreq() */
    FS803_OUTPUT_FREQ,

    /*  output bandwidth                         set by MT2060_ChangeFreq() */
    FS803_OUTPUT_BW,

    /*  min inter-tuner LO separation                 (default: 1000000 Hz) */
    FS803_LO_SEPARATION,

    /*  ID of avoid-spurs algorithm in use            compile-time constant */
    FS803_AS_ALG,

    /*  max # of intra-tuner harmonics                        (default: 5)  */
    FS803_MAX_HARM1,

    /*  max # of inter-tuner harmonics                        (default: 5)  */
    FS803_MAX_HARM2,

    /*  # of 1st IF exclusion zones used         set by MT2060_ChangeFreq() */
    FS803_EXCL_ZONES,
                 
    /*  # of spurs found/avoided                 set by MT2060_ChangeFreq() */
    FS803_NUM_SPURS,
          
    /*  >0 spurs avoided                         set by MT2060_ChangeFreq() */
    FS803_SPUR_AVOIDED,
              
    /*  >0 spurs in output (mathematically)      set by MT2060_ChangeFreq() */
    FS803_SPUR_PRESENT,

    FS803_EOP                    /*  last entry in enumerated list         */
} FS803_Param;


struct fs803_priv {
	struct fs803_config *cfg;
	struct i2c_adapter   *i2c;

	u32 frequency;
	u32 bandwidth;
	u16 if1_freq;
	u8  fmfreq;
};

extern int RF_IF_FS803_X100[];

Handle_t FS803_GetFS803Info(U8Data ucSlaveDemod);
UData_t FS803_GetParam(Handle_t h,FS803_Param param,UData_t*  pValue);
UData_t FS803_SetParam(Handle_t h,FS803_Param param,UData_t nValue);


//extern struct dvb_frontend * mt2060_attach(struct dvb_frontend *fe);
extern struct dvb_frontend * fs803_attach(struct dvb_frontend *fe);

#endif
